<?php

namespace App\Enums;

enum VehicleStatus: string
{
    case FREE = 'free';
    case BUSY = 'busy';
    case UNAVAILABLE = 'unavailable';

    public function labelHr(): string
    {
        return match ($this) {
            self::FREE => 'Slobodno',
            self::BUSY => 'Zauzeto',
            self::UNAVAILABLE => 'Nedostupno',
        };
    }
}
