<?php

namespace App\Filament\Resources;

use App\Filament\Resources\AppNotificationResource\Pages;
use App\Models\AppNotification;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class AppNotificationResource extends Resource
{
    protected static ?string $model = AppNotification::class;
    protected static ?string $navigationIcon = 'heroicon-o-bell';
    protected static ?string $navigationGroup = 'Postavke';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Obavijest')->schema([
                Forms\Components\TextInput::make('type')->label('Tip')->required(),
                Forms\Components\TextInput::make('title')->label('Naslov')->required(),
                Forms\Components\Textarea::make('body')->label('Poruka')->columnSpanFull(),
                Forms\Components\DateTimePicker::make('due_at')->label('Rok'),
                Forms\Components\Toggle::make('is_sent')->label('Poslano')->default(false),
            ])->columns(2),

        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('type')->label('Tip')->searchable(),
            Tables\Columns\TextColumn::make('title')->label('Naslov')->searchable(),
            Tables\Columns\TextColumn::make('due_at')->label('Rok')->dateTime()->sortable(),
            Tables\Columns\IconColumn::make('is_sent')->label('Poslano')->boolean(),

        ])->filters([

        ])->actions([
            Tables\Actions\EditAction::make(),
        ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAppNotifications::route('/'),
            'create' => Pages\CreateAppNotification::route('/create'),
            'edit' => Pages\EditAppNotification::route('/{record}/edit'),

        ];
    }
}
