<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CompanyResource\Pages;
use App\Models\Company;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class CompanyResource extends Resource
{
    protected static ?string $model = Company::class;
    protected static ?string $navigationIcon = 'heroicon-o-building-office';
    protected static ?string $navigationGroup = 'Postavke';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Tvrtka')->schema([
                Forms\Components\TextInput::make('name')->label('Naziv')->required(),
                Forms\Components\TextInput::make('oib')->label('OIB'),
                Forms\Components\TextInput::make('iban')->label('IBAN'),
                Forms\Components\TextInput::make('address')->label('Adresa'),
                Forms\Components\TextInput::make('email')->label('Email')->email(),
                Forms\Components\TextInput::make('phone')->label('Telefon'),
                Forms\Components\Toggle::make('is_default')->label('Default')->default(false),
                Forms\Components\Textarea::make('notes')->label('Napomena')->columnSpanFull(),
            ])->columns(2),

        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('name')->label('Naziv')->searchable(),
            Tables\Columns\TextColumn::make('oib')->label('OIB'),
            Tables\Columns\IconColumn::make('is_default')->label('Default')->boolean(),

        ])->filters([

        ])->actions([
            Tables\Actions\EditAction::make(),
        ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCompanies::route('/'),
            'create' => Pages\CreateCompany::route('/create'),
            'edit' => Pages\EditCompany::route('/{record}/edit'),

        ];
    }
}
