<?php

namespace App\Filament\Resources;

use App\Filament\Resources\DamageResource\Pages;
use App\Models\Damage;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class DamageResource extends Resource
{
    protected static ?string $model = Damage::class;
    protected static ?string $navigationIcon = 'heroicon-o-exclamation-triangle';
    protected static ?string $navigationGroup = 'RentX';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Šteta')->schema([
                Forms\Components\Select::make('vehicle_id')->label('Vozilo')->relationship('vehicle', 'registration')->searchable()->required(),
                Forms\Components\Select::make('driver_id')->label('Vozač (opcionalno)')->relationship('driver', 'first_name')->searchable(),
                Forms\Components\Select::make('contract_id')->label('Ugovor (opcionalno)')->relationship('contract', 'number')->searchable(),
                Forms\Components\DatePicker::make('damage_date')->label('Datum')->required(),
                Forms\Components\Textarea::make('description')->label('Opis')->required()->columnSpanFull(),
                Forms\Components\TextInput::make('cost')->label('Trošak')->numeric()->default(0),
                Forms\Components\Select::make('status')->label('Status')->options([
                    'open' => 'Neriješeno',
                    'resolved' => 'Riješeno',
                ])->required()->default('open'),
                Forms\Components\Textarea::make('notes')->label('Napomena')->columnSpanFull(),
            ])->columns(2),

        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('vehicle.registration')->label('Vozilo')->searchable(),
            Tables\Columns\TextColumn::make('damage_date')->label('Datum')->date()->sortable(),
            Tables\Columns\TextColumn::make('driver.full_name')->label('Vozač'),
            Tables\Columns\TextColumn::make('cost')->label('Trošak')->money('EUR'),
            Tables\Columns\TextColumn::make('status')->label('Status')->sortable(),

        ])->filters([
            Tables\Filters\SelectFilter::make('status')->options([
                'open' => 'Neriješeno', 'resolved' => 'Riješeno',
            ]),

        ])->actions([
            Tables\Actions\EditAction::make(),
        ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListDamages::route('/'),
            'create' => Pages\CreateDamage::route('/create'),
            'edit' => Pages\EditDamage::route('/{record}/edit'),

        ];
    }
}
