<?php

namespace App\Filament\Resources;

use App\Filament\Resources\DocumentResource\Pages;
use App\Models\Document;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class DocumentResource extends Resource
{
    protected static ?string $model = Document::class;
    protected static ?string $navigationIcon = 'heroicon-o-folder';
    protected static ?string $navigationGroup = 'Postavke';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Dokument')->schema([
                Forms\Components\Select::make('company_id')->label('Tvrtka')->relationship('company', 'name')->searchable(),
                Forms\Components\TextInput::make('title')->label('Naslov')->required(),
                Forms\Components\TextInput::make('type')->label('Tip'),
                Forms\Components\DatePicker::make('expires_at')->label('Ističe'),
                Forms\Components\TextInput::make('file_path')->label('File path')->columnSpanFull(),
                Forms\Components\Textarea::make('notes')->label('Napomena')->columnSpanFull(),
            ])->columns(2),

        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('title')->label('Naslov')->searchable(),
            Tables\Columns\TextColumn::make('type')->label('Tip')->sortable(),
            Tables\Columns\TextColumn::make('expires_at')->label('Ističe')->date()->sortable(),

        ])->filters([

        ])->actions([
            Tables\Actions\EditAction::make(),
        ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListDocuments::route('/'),
            'create' => Pages\CreateDocument::route('/create'),
            'edit' => Pages\EditDocument::route('/{record}/edit'),

        ];
    }
}
