<?php

namespace App\Filament\Resources;

use App\Filament\Resources\LeasingResource\Pages;
use App\Models\Leasing;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class LeasingResource extends Resource
{
    protected static ?string $model = Leasing::class;
    protected static ?string $navigationIcon = 'heroicon-o-credit-card';
    protected static ?string $navigationGroup = 'RentX';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Leasing')->schema([
                Forms\Components\Select::make('vehicle_id')->label('Vozilo')->relationship('vehicle', 'registration')->searchable()->required(),
                Forms\Components\TextInput::make('leasing_company')->label('Leasing kuća')->required(),
                Forms\Components\DatePicker::make('date_from')->label('Od')->required(),
                Forms\Components\DatePicker::make('date_to')->label('Do')->nullable(),
                Forms\Components\TextInput::make('monthly_rate')->label('Mjesečna rata')->numeric()->default(0),
                Forms\Components\Select::make('status')->label('Status')->options([
                    'active' => 'Aktivan',
                    'closed' => 'Završen',
                ])->required()->default('active'),
                Forms\Components\Textarea::make('notes')->label('Napomena')->columnSpanFull(),
            ])->columns(2),

        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('vehicle.registration')->label('Vozilo')->searchable(),
            Tables\Columns\TextColumn::make('leasing_company')->label('Leasing kuća')->searchable(),
            Tables\Columns\TextColumn::make('monthly_rate')->label('Rata')->money('EUR'),
            Tables\Columns\TextColumn::make('status')->label('Status')->sortable(),

        ])->filters([
            Tables\Filters\SelectFilter::make('status')->options([
                'active' => 'Aktivan', 'closed' => 'Završen',
            ]),

        ])->actions([
            Tables\Actions\EditAction::make(),
        ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListLeasings::route('/'),
            'create' => Pages\CreateLeasing::route('/create'),
            'edit' => Pages\EditLeasing::route('/{record}/edit'),

        ];
    }
}
