<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ReservationResource\Pages;
use App\Models\Reservation;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class ReservationResource extends Resource
{
    protected static ?string $model = Reservation::class;
    protected static ?string $navigationIcon = 'heroicon-o-calendar-days';
    protected static ?string $navigationGroup = 'RentX';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Rezervacija')->schema([
                Forms\Components\Select::make('vehicle_id')->label('Vozilo')->relationship('vehicle', 'registration')->searchable()->required(),
                Forms\Components\Select::make('driver_id')->label('Vozač (opcionalno)')->relationship('driver', 'first_name')->searchable(),
                Forms\Components\DateTimePicker::make('date_from')->label('Od')->required(),
                Forms\Components\DateTimePicker::make('date_to')->label('Do')->required(),
                Forms\Components\Select::make('status')->label('Status')->options([
                    'pending' => 'Na čekanju',
                    'confirmed' => 'Potvrđeno',
                    'canceled' => 'Otkazano',
                ])->required()->default('pending'),
                Forms\Components\Textarea::make('notes')->label('Napomena')->columnSpanFull(),
            ])->columns(2),

        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('vehicle.registration')->label('Vozilo')->searchable(),
            Tables\Columns\TextColumn::make('driver.full_name')->label('Vozač'),
            Tables\Columns\TextColumn::make('date_from')->label('Od')->dateTime()->sortable(),
            Tables\Columns\TextColumn::make('date_to')->label('Do')->dateTime()->sortable(),
            Tables\Columns\TextColumn::make('status')->label('Status')->sortable(),

        ])->filters([
            Tables\Filters\SelectFilter::make('status')->options([
                'pending' => 'Na čekanju',
                'confirmed' => 'Potvrđeno',
                'canceled' => 'Otkazano',
            ]),

        ])->actions([
            Tables\Actions\EditAction::make(),
        ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListReservations::route('/'),
            'create' => Pages\CreateReservation::route('/create'),
            'edit' => Pages\EditReservation::route('/{record}/edit'),

        ];
    }
}
