<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ServiceRecordResource\Pages;
use App\Models\ServiceRecord;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class ServiceRecordResource extends Resource
{
    protected static ?string $model = ServiceRecord::class;
    protected static ?string $navigationIcon = 'heroicon-o-wrench-screwdriver';
    protected static ?string $navigationGroup = 'RentX';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Servis / Popravak')->schema([
                Forms\Components\Select::make('vehicle_id')->label('Vozilo')->relationship('vehicle', 'registration')->searchable()->required(),
                Forms\Components\Select::make('type')->label('Tip')->options([
                    'service' => 'Servis',
                    'repair' => 'Popravak',
                    'tires' => 'Gume',
                ])->required(),
                Forms\Components\DatePicker::make('service_date')->label('Datum')->required(),
                Forms\Components\TextInput::make('cost')->label('Trošak')->numeric()->default(0),
                Forms\Components\Toggle::make('is_completed')->label('Završeno')->default(true),
                Forms\Components\Textarea::make('description')->label('Opis')->columnSpanFull(),
                Forms\Components\TextInput::make('attachment_path')->label('Prilog path')->columnSpanFull(),
            ])->columns(2),

        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('vehicle.registration')->label('Vozilo')->searchable(),
            Tables\Columns\TextColumn::make('type')->label('Tip')->sortable(),
            Tables\Columns\TextColumn::make('service_date')->label('Datum')->date()->sortable(),
            Tables\Columns\TextColumn::make('cost')->label('Trošak')->money('EUR'),
            Tables\Columns\IconColumn::make('is_completed')->label('Završeno')->boolean(),

        ])->filters([
            Tables\Filters\SelectFilter::make('type')->options([
                'service' => 'Servis', 'repair' => 'Popravak', 'tires' => 'Gume',
            ]),

        ])->actions([
            Tables\Actions\EditAction::make(),
        ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListServiceRecords::route('/'),
            'create' => Pages\CreateServiceRecord::route('/create'),
            'edit' => Pages\EditServiceRecord::route('/{record}/edit'),

        ];
    }
}
