<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class LandingController extends Controller
{
    /**
     * Demo dataset for the landing pages.
     *
     * When you connect database models later, you can replace this with
     * Vehicle::query()->where('is_active',1)->paginate(...), etc.
     */
    private function demoVehicles(): array
    {
        return [
            [
                'slug' => 'vw-golf-7-1-6-tdi',
                'name' => 'VW Golf 7 1.6 TDI',
                'year' => 2018,
                'fuel' => 'Dizel',
                'transmission' => 'Ručni',
                'seats' => 5,
                'price_day' => 35,
                'price_month' => 690,
                'image' => '/assets/rentx/demo/golf.jpg',
                'tags' => ['AC', 'Bluetooth', 'Tempomat'],
            ],
            [
                'slug' => 'skoda-octavia-2-0-tdi',
                'name' => 'Škoda Octavia 2.0 TDI',
                'year' => 2019,
                'fuel' => 'Dizel',
                'transmission' => 'Automatski',
                'seats' => 5,
                'price_day' => 45,
                'price_month' => 890,
                'image' => '/assets/rentx/demo/octavia.jpg',
                'tags' => ['Navi', 'Kamera', 'AC'],
            ],
            [
                'slug' => 'toyota-yaris-hybrid',
                'name' => 'Toyota Yaris Hybrid',
                'year' => 2020,
                'fuel' => 'Hibrid',
                'transmission' => 'Automatski',
                'seats' => 5,
                'price_day' => 40,
                'price_month' => 790,
                'image' => '/assets/rentx/demo/yaris.jpg',
                'tags' => ['Hybrid', 'AC', 'CarPlay'],
            ],
            [
                'slug' => 'renault-clio-1-5-dci',
                'name' => 'Renault Clio 1.5 dCi',
                'year' => 2017,
                'fuel' => 'Dizel',
                'transmission' => 'Ručni',
                'seats' => 5,
                'price_day' => 30,
                'price_month' => 590,
                'image' => '/assets/rentx/demo/clio.jpg',
                'tags' => ['AC', 'USB', 'Economy'],
            ],
        ];
    }

    public function home()
    {
        $vehicles = $this->demoVehicles();
        return view('landing.home', compact('vehicles'));
    }

    public function vehicles(Request $request)
    {
        $vehicles = $this->demoVehicles();

        // Simple search (demo)
        $q = trim((string) $request->get('q', ''));
        if ($q !== '') {
            $vehicles = array_values(array_filter($vehicles, fn ($v) =>
                str_contains(mb_strtolower($v['name']), mb_strtolower($q))
            ));
        }

        return view('landing.vehicles', [
            'vehicles' => $vehicles,
            'q' => $q,
        ]);
    }

    public function vehicleShow(string $slug)
    {
        $vehicles = $this->demoVehicles();
        $vehicle = collect($vehicles)->firstWhere('slug', $slug);
        abort_unless($vehicle, 404);

        return view('landing.vehicle', compact('vehicle'));
    }

    public function pricing()
    {
        return view('landing.pricing');
    }

    public function contact()
    {
        return view('landing.contact', ['sent' => false]);
    }

    public function sendContact(Request $request)
    {
        // Demo validation – later you can connect this to Mail, CRM, etc.
        $data = $request->validate([
            'name' => ['required','string','max:120'],
            'email' => ['required','email','max:190'],
            'message' => ['required','string','max:2000'],
        ]);

        // For now we just simulate success.
        // If you want, we can log it: logger()->info('Contact form', $data);

        return view('landing.contact', ['sent' => true]);
    }
}
