<?php

namespace App\Models;

use App\Enums\DriverStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Carbon;

class Driver extends Model
{
    use HasFactory;

    protected $fillable = [
        'first_name','last_name','oib',
        'id_card_number','driving_license_number',
        'id_card_expires_at','driving_license_expires_at',
        'phone','email','address',
        'status','blacklist_reason','notes',
    ];

    protected $casts = [
        'id_card_expires_at' => 'date',
        'driving_license_expires_at' => 'date',
        'status' => DriverStatus::class,
    ];

    public function contracts(): HasMany { return $this->hasMany(Contract::class); }
    public function reservations(): HasMany { return $this->hasMany(Reservation::class); }
    public function damages(): HasMany { return $this->hasMany(Damage::class); }

    public function getFullNameAttribute(): string
    {
        return trim(($this->first_name ?? '').' '.($this->last_name ?? ''));
    }

    public function isBlacklisted(): bool
    {
        return $this->status === DriverStatus::BLACKLISTED;
    }

    public function documentsExpired(): array
    {
        $errors = [];
        $today = Carbon::today();

        if ($this->id_card_expires_at && $this->id_card_expires_at->lt($today)) {
            $errors[] = 'Osobna iskaznica je istekla.';
        }
        if ($this->driving_license_expires_at && $this->driving_license_expires_at->lt($today)) {
            $errors[] = 'Vozačka dozvola je istekla.';
        }
        return $errors;
    }
}
