<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Leasing extends Model
{
    use HasFactory;

    protected $fillable = [
        'vehicle_id','leasing_company','date_from','date_to','monthly_rate','status','notes','created_by',
    ];

    protected $casts = [
        'date_from' => 'date',
        'date_to' => 'date',
        'monthly_rate' => 'decimal:2',
    ];

    public function vehicle(): BelongsTo { return $this->belongsTo(Vehicle::class); }
    public function payments(): HasMany { return $this->hasMany(LeasingPayment::class); }
}
