<?php

namespace App\Models;

use App\Enums\ServiceType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ServiceRecord extends Model
{
    use HasFactory;

    protected $fillable = [
        'vehicle_id','type','service_date','cost','description','is_completed','attachment_path',
    ];

    protected $casts = [
        'service_date' => 'date',
        'cost' => 'decimal:2',
        'is_completed' => 'boolean',
        'type' => ServiceType::class,
    ];

    public function vehicle(): BelongsTo { return $this->belongsTo(Vehicle::class); }
}
