<?php

namespace App\Services;

use App\Models\Driver;

class ContractValidator
{
    /** Vrati listu grešaka (prazno = OK). */
    public function validateDriver(Driver $driver): array
    {
        $errors = [];

        if ($driver->isBlacklisted()) {
            $errors[] = 'Vozač je na crnoj listi.';
        }

        foreach ($driver->documentsExpired() as $err) {
            $errors[] = $err;
        }

        return $errors;
    }
}
