<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('contracts', function (Blueprint $table) {
            $table->id();
            $table->string('number')->unique();
            $table->foreignId('vehicle_id')->constrained('vehicles');
            $table->foreignId('driver_id')->constrained('drivers');
            $table->dateTime('date_from')->index();
            $table->dateTime('date_to')->index();
            $table->decimal('price', 12, 2)->default(0);
            $table->decimal('deposit', 12, 2)->default(0);
            $table->unsignedInteger('included_km')->nullable();
            $table->decimal('extra_km_rate', 12, 2)->nullable();
            $table->unsignedInteger('pickup_km')->nullable();
            $table->unsignedInteger('return_km')->nullable();
            $table->string('fuel_level_pickup')->nullable();
            $table->string('fuel_level_return')->nullable();
            $table->text('notes')->nullable();
            $table->string('status')->default('active')->index();
            $table->timestamps();
            $table->index(['vehicle_id', 'status']);
            $table->index(['driver_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('contracts');
    }
};
