
@php($featured = $featured ?? [])

@extends('layouts.landing')


@section('content')
    <section class="hero">
        <div class="container hero__inner">
            <div class="hero__copy">
                <h1>Najam vozila, bez komplikacija.</h1>
                <p class="lead">
                    Brza rezervacija, jasni uvjeti, plaćanje na vrijeme i potpuna kontrola troškova –
                    sve na jednom mjestu.
                </p>

                <form class="search" action="{{ route('vehicles') }}" method="get">
                    <div class="search__grid">
                        <div class="field">
                            <label>Lokacija</label>
                            <input name="city" type="text" placeholder="Zagreb, Split, Skopje..." value="{{ request('city') }}">
                        </div>
                        <div class="field">
                            <label>Od</label>
                            <input name="from" type="date" value="{{ request('from') }}">
                        </div>
                        <div class="field">
                            <label>Do</label>
                            <input name="to" type="date" value="{{ request('to') }}">
                        </div>
                        <div class="field field--btn">
                            <button class="btn btn--primary" type="submit">Pretraži vozila</button>
                        </div>
                    </div>
                    <div class="search__hint">Demo forma – kasnije spajamo na rezervacije i stvarnu dostupnost.</div>
                </form>

                <div class="hero__cta">
                    <a class="btn btn--primary" href="{{ route('vehicles') }}">Pogledaj ponudu</a>
                    <a class="btn btn--ghost" href="/admin">Uđi u Admin</a>
                </div>

                <div class="trust">
                    <div class="trust__item"><strong>+ Rezervacije</strong><span>brzo i jasno</span></div>
                    <div class="trust__item"><strong>+ Ugovori</strong><span>sve na jednom mjestu</span></div>
                    <div class="trust__item"><strong>+ Troškovi</strong><span>profit po vozilu</span></div>
                </div>
            </div>

            <div class="hero__visual">
                <div class="card card--glass">
                    <div class="card__title">Izdvojena vozila</div>
                    <div class="grid grid--cards">
                        @foreach($featured as $v)
                            <a class="vehicle" href="{{ route('vehicles.show', $v['slug']) }}">
                                <div class="vehicle__top">
                                    <div class="vehicle__badge">{{ $v['fuel'] }}</div>
                                    <div class="vehicle__name">{{ $v['brand'] }} {{ $v['model'] }}</div>
                                    <div class="vehicle__meta">{{ $v['year'] }} • {{ $v['transmission'] }} • {{ $v['seats'] }} sj.</div>
                                </div>
                                <div class="vehicle__bottom">
                                    <div class="price">
                                        <span class="price__value">{{ number_format($v['price_day'], 0) }}€</span>
                                        <span class="price__unit">/ dan</span>
                                    </div>
                                    <span class="btn btn--soft btn--sm">Detalji</span>
                                </div>
                            </a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section">
        <div class="container">
            <div class="section__head">
                <h2>Zašto RentX?</h2>
                <p class="muted">Ovo je početni dizajn inspiriran modernim rent-a-car landing stranicama. Kasnije ga prilagođavamo 1:1 po želji.</p>
            </div>

            <div class="grid grid--3">
                <div class="feature">
                    <div class="feature__icon">⚡</div>
                    <h3>Brza rezervacija</h3>
                    <p>Rezervacija kao ugovor: odaberi vozilo, period i sve ostalo – spremno za naplatu.</p>
                </div>
                <div class="feature">
                    <div class="feature__icon">🧾</div>
                    <h3>Računi i ponude</h3>
                    <p>Izrada računa/ponude + slanje na email, uz filtre po vozilu, registraciji, mjesecu i statusu.</p>
                </div>
                <div class="feature">
                    <div class="feature__icon">📈</div>
                    <h3>Profit po vozilu</h3>
                    <p>Servisi i troškovi se raspodjeljuju po mjesecima – na kraju vidiš čistu zaradu po vozilu.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="section section--soft">
        <div class="container">
            <div class="cta">
                <div>
                    <h2>Spreman za backend panel?</h2>
                    <p class="muted">U ovom starteru koristi se Filament Admin Panel za brzi CRUD (vozila, vozači, ugovori...).</p>
                </div>
                <a class="btn btn--primary" href="/admin">Otvori Admin</a>
            </div>
        </div>
    </section>
@endsection
