@extends('layouts.landing')

@section('content')
    <section class="section">
        <div class="container">
            <div class="section__head">
                <h1>Vozila</h1>
                <p class="muted">Prikaz je trenutno demo (iz koda) – kasnije povlačimo iz baze.</p>
            </div>

            <div class="grid grid--3">
                @foreach($vehicles as $v)
                    <article class="card">
                        <div class="card__media">
                            <div class="badge">{{ $v['fuel'] }}</div>
                            <div class="placeholder">🚗</div>
                        </div>
                        <div class="card__body">
                            <div class="card__title">{{ $v['brand'] }} {{ $v['model'] }}</div>
                            <div class="card__meta">
                                <span>{{ $v['year'] }}</span>
                                <span>•</span>
                                <span>{{ $v['seats'] }} sjedala</span>
                                <span>•</span>
                                <span>{{ $v['transmission'] }}</span>
                            </div>
                            <div class="card__price">
                                <strong>{{ number_format($v['price_per_day_eur'], 0) }}€</strong>
                                <span class="muted">/ dan</span>
                            </div>
                            <div class="card__actions">
                                <a class="btn btn--ghost" href="{{ route('vehicles.show', $v['slug']) }}">Detalji</a>
                                <a class="btn" href="{{ route('contact') }}">Rezerviraj</a>
                            </div>
                        </div>
                    </article>
                @endforeach
            </div>

            <div class="section__foot">
                <a class="btn btn--ghost" href="{{ route('pricing') }}">Pogledaj pakete</a>
            </div>
        </div>
    </section>
@endsection
