<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LandingController;

/*
|--------------------------------------------------------------------------
| Public (landing) routes
|--------------------------------------------------------------------------
*/

Route::get('/', [LandingController::class, 'home'])->name('home');

Route::get('/vozila', [LandingController::class, 'vehicles'])->name('vehicles.index');
Route::get('/vozila/{slug}', [LandingController::class, 'vehicleShow'])->name('vehicles.show');

Route::get('/cijene', [LandingController::class, 'pricing'])->name('pricing');

Route::get('/kontakt', [LandingController::class, 'contact'])->name('contact');
Route::post('/kontakt', [LandingController::class, 'sendContact'])->name('contact.send');

// Friendly shortcut to admin panel
Route::get('/panel', function () {
    return redirect('/admin');
})->name('panel');

// Alias ако во шаблонот имаш route('vehicles')
Route::get('/vehicles', function () {
    return redirect()->route('vehicles.index');
})->name('vehicles');

