<?php

namespace App\Enums;

enum ContractStatus: string
{
    case ACTIVE = 'active';
    case CLOSED = 'closed';
    case CANCELED = 'canceled';

    public function labelHr(): string
    {
        return match ($this) {
            self::ACTIVE => 'Aktivan',
            self::CLOSED => 'Završen',
            self::CANCELED => 'Otkazan',
        };
    }
}
