<?php

namespace App\Enums;

enum ReservationStatus: string
{
    case PENDING = 'pending';
    case CONFIRMED = 'confirmed';
    case CANCELED = 'canceled';

    public function labelHr(): string
    {
        return match ($this) {
            self::PENDING => 'Na čekanju',
            self::CONFIRMED => 'Potvrđeno',
            self::CANCELED => 'Otkazano',
        };
    }
}
