<?php

namespace App\Filament\Resources;

use App\Filament\Resources\BillingDocumentResource\Pages;
use App\Models\BillingDocument;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class BillingDocumentResource extends Resource
{
    protected static ?string $model = BillingDocument::class;
    protected static ?string $navigationIcon = 'heroicon-o-banknotes';
    protected static ?string $navigationGroup = 'Financije';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Dokument')->schema([
                Forms\Components\Select::make('type')->label('Tip')->options([
                    'invoice' => 'Račun',
                    'offer' => 'Ponuda',
                ])->required()->default('invoice'),
                Forms\Components\TextInput::make('number')->label('Broj')->required(),
                Forms\Components\DatePicker::make('doc_date')->label('Datum')->required(),
                Forms\Components\TextInput::make('client_name')->label('Klijent'),
                Forms\Components\TextInput::make('client_email')->label('Email')->email(),
                Forms\Components\TextInput::make('client_oib')->label('OIB'),
                Forms\Components\Select::make('status')->label('Status')->options([
                    'draft' => 'Draft',
                    'sent' => 'Poslano',
                    'paid' => 'Plaćeno',
                    'canceled' => 'Otkazano',
                ])->required()->default('draft'),
                Forms\Components\Textarea::make('notes')->label('Napomena')->columnSpanFull(),
            ])->columns(2),
            Forms\Components\Section::make('Iznosi')->schema([
                Forms\Components\TextInput::make('subtotal')->label('Međuzbroj')->numeric()->default(0),
                Forms\Components\TextInput::make('discount')->label('Popust')->numeric()->default(0),
                Forms\Components\TextInput::make('total')->label('Ukupno')->numeric()->default(0),
            ])->columns(3),

        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('type')->label('Tip')->sortable(),
            Tables\Columns\TextColumn::make('number')->label('Broj')->searchable(),
            Tables\Columns\TextColumn::make('doc_date')->label('Datum')->date()->sortable(),
            Tables\Columns\TextColumn::make('client_name')->label('Klijent')->searchable(),
            Tables\Columns\TextColumn::make('total')->label('Ukupno')->money('EUR'),
            Tables\Columns\TextColumn::make('status')->label('Status')->sortable(),

        ])->filters([
            Tables\Filters\SelectFilter::make('type')->options([
                'invoice' => 'Račun', 'offer' => 'Ponuda',
            ]),
            Tables\Filters\SelectFilter::make('status')->options([
                'draft' => 'Draft', 'sent' => 'Poslano', 'paid' => 'Plaćeno', 'canceled' => 'Otkazano',
            ]),

        ])->actions([
            Tables\Actions\EditAction::make(),
        ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBillingDocuments::route('/'),
            'create' => Pages\CreateBillingDocument::route('/create'),
            'edit' => Pages\EditBillingDocument::route('/{record}/edit'),

        ];
    }
}
