<?php

namespace App\Filament\Resources;

use App\Filament\Resources\DriverResource\Pages;
use App\Models\Driver;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class DriverResource extends Resource
{
    protected static ?string $model = Driver::class;
    protected static ?string $navigationIcon = 'heroicon-o-identification';
    protected static ?string $navigationGroup = 'RentX';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Osnovno')->schema([
                Forms\Components\TextInput::make('first_name')->label('Ime')->required(),
                Forms\Components\TextInput::make('last_name')->label('Prezime')->required(),
                Forms\Components\TextInput::make('oib')->label('OIB')->maxLength(32),
                Forms\Components\TextInput::make('phone')->label('Telefon')->maxLength(50),
                Forms\Components\TextInput::make('email')->label('Email')->email()->maxLength(150),
                Forms\Components\TextInput::make('address')->label('Adresa')->maxLength(255),
            ])->columns(2),

            Forms\Components\Section::make('Dokumenti')->schema([
                Forms\Components\TextInput::make('id_card_number')->label('Broj osobne')->maxLength(50),
                Forms\Components\DatePicker::make('id_card_expires_at')->label('Osobna ističe'),
                Forms\Components\TextInput::make('driving_license_number')->label('Broj vozačke')->maxLength(50),
                Forms\Components\DatePicker::make('driving_license_expires_at')->label('Vozačka ističe'),
            ])->columns(2),

            Forms\Components\Section::make('Status')->schema([
                Forms\Components\Select::make('status')->label('Status')->options([
                    'active' => 'Aktivan',
                    'blacklisted' => 'Crna lista',
                ])->required()->default('active'),
                Forms\Components\TextInput::make('blacklist_reason')->label('Razlog crne liste')
                    ->visible(fn ($get) => $get('status') === 'blacklisted'),
                Forms\Components\Textarea::make('notes')->label('Napomena')->columnSpanFull(),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('full_name')->label('Vozač')->searchable(['first_name','last_name']),
                Tables\Columns\TextColumn::make('oib')->label('OIB')->searchable(),
                Tables\Columns\TextColumn::make('phone')->label('Telefon'),
                Tables\Columns\TextColumn::make('status')->label('Status')->sortable(),
                Tables\Columns\TextColumn::make('driving_license_expires_at')->label('Vozačka ističe')->date(),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('status')->label('Status')->options([
                    'active' => 'Aktivan',
                    'blacklisted' => 'Crna lista',
                ]),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListDrivers::route('/'),
            'create' => Pages\CreateDriver::route('/create'),
            'edit' => Pages\EditDriver::route('/{record}/edit'),
        ];
    }
}
