<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ItemResource\Pages;
use App\Models\Item;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class ItemResource extends Resource
{
    protected static ?string $model = Item::class;
    protected static ?string $navigationIcon = 'heroicon-o-archive-box';
    protected static ?string $navigationGroup = 'Financije';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Artikl')->schema([
                Forms\Components\TextInput::make('name')->label('Naziv')->required(),
                Forms\Components\Select::make('unit')->label('Jedinica')->options([
                    'kom' => 'Kom',
                    'dan' => 'Dan',
                    'km' => 'KM',
                ])->required()->default('kom'),
                Forms\Components\TextInput::make('price')->label('Cijena')->numeric()->default(0),
                Forms\Components\Toggle::make('is_active')->label('Aktivno')->default(true),
                Forms\Components\Textarea::make('description')->label('Opis')->columnSpanFull(),
            ])->columns(2),

        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('name')->label('Naziv')->searchable(),
            Tables\Columns\TextColumn::make('unit')->label('Jedinica'),
            Tables\Columns\TextColumn::make('price')->label('Cijena')->money('EUR'),
            Tables\Columns\IconColumn::make('is_active')->label('Aktivno')->boolean(),

        ])->filters([

        ])->actions([
            Tables\Actions\EditAction::make(),
        ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListItems::route('/'),
            'create' => Pages\CreateItem::route('/create'),
            'edit' => Pages\EditItem::route('/{record}/edit'),

        ];
    }
}
