<?php

namespace App\Filament\Resources;

use App\Filament\Resources\VehicleResource\Pages;
use App\Models\Vehicle;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class VehicleResource extends Resource
{
    protected static ?string $model = Vehicle::class;
    protected static ?string $navigationIcon = 'heroicon-o-truck';
    protected static ?string $navigationGroup = 'RentX';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Osnovno')->schema([
                Forms\Components\TextInput::make('make')->label('Marka')->required()->maxLength(100),
                Forms\Components\TextInput::make('model')->label('Model')->required()->maxLength(100),
                Forms\Components\TextInput::make('registration')->label('Registracija')->required()->maxLength(20),
                Forms\Components\TextInput::make('vin')->label('VIN')->maxLength(64),
                Forms\Components\TextInput::make('year')->label('Godina')->numeric(),
                Forms\Components\Select::make('fuel_type')->label('Gorivo')->options([
                    'diesel' => 'Dizel', 'benzin' => 'Benzin', 'hibrid' => 'Hibrid', 'struja' => 'Električno',
                ])->searchable(),
                Forms\Components\Select::make('transmission')->label('Mjenjač')->options([
                    'manual' => 'Ručni', 'auto' => 'Automatik',
                ]),
                Forms\Components\TextInput::make('seats')->label('Sjedala')->numeric(),
                Forms\Components\TextInput::make('doors')->label('Vrata')->numeric(),
                Forms\Components\TextInput::make('color')->label('Boja')->maxLength(50),
            ])->columns(2),

            Forms\Components\Section::make('Kilometraža & status')->schema([
                Forms\Components\TextInput::make('start_km')->label('Početni km')->numeric()->default(0),
                Forms\Components\TextInput::make('current_km')->label('Trenutni km')->numeric()->default(0),
                Forms\Components\Select::make('status')->label('Status')->options([
                    'free' => 'Slobodno',
                    'busy' => 'Zauzeto',
                    'unavailable' => 'Nedostupno',
                ])->required()->default('free'),
                Forms\Components\Toggle::make('is_active')->label('Aktivno')->default(true),
                Forms\Components\Textarea::make('notes')->label('Napomena')->columnSpanFull(),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('make')->label('Marka')->searchable(),
                Tables\Columns\TextColumn::make('model')->label('Model')->searchable(),
                Tables\Columns\TextColumn::make('registration')->label('Registracija')->searchable(),
                Tables\Columns\TextColumn::make('current_km')->label('KM')->sortable(),
                Tables\Columns\TextColumn::make('status')->label('Status')->sortable(),
                Tables\Columns\IconColumn::make('is_active')->label('Aktivno')->boolean(),
                Tables\Columns\TextColumn::make('updated_at')->label('Ažurirano')->dateTime()->sortable(),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('status')->label('Status')->options([
                    'free' => 'Slobodno', 'busy' => 'Zauzeto', 'unavailable' => 'Nedostupno',
                ]),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListVehicles::route('/'),
            'create' => Pages\CreateVehicle::route('/create'),
            'edit' => Pages\EditVehicle::route('/{record}/edit'),
        ];
    }
}
