<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class AdminAuthController extends Controller
{
    public function showLogin()
    {
        return view('admin.login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'username' => ['required', 'string'],
            'password' => ['required', 'string'],
        ]);

        $user = (string) env('ADMIN_USER', 'admin');
        $pass = (string) env('ADMIN_PASS', 'admin123');

        if (hash_equals($user, (string) $request->input('username')) &&
            hash_equals($pass, (string) $request->input('password'))) {

            $request->session()->put('admin_logged_in', true);
            $request->session()->regenerate();

            return redirect()->route('admin.dashboard');
        }

        return back()->withErrors([
            'username' => 'Pogrešno korisničko ime ili lozinka.',
        ])->withInput($request->only('username'));
    }

    public function logout(Request $request)
    {
        $request->session()->forget('admin_logged_in');
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('admin.login');
    }
}
