<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class AdminAuth
{
    public function handle(Request $request, Closure $next)
    {
        if ($request->session()->get('admin_logged_in') === true) {
            return $next($request);
        }

        // Allow access to the login endpoints without redirect loops
        if (
            $request->routeIs('admin.login') ||
            $request->routeIs('admin.login.submit') ||
            $request->routeIs('admin.logout')
        ) {
            return $next($request);
        }

        return redirect()->route('admin.login');
    }
}
