<?php

namespace App\Models;

use App\Enums\BillingDocType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BillingDocument extends Model
{
    use HasFactory;

    protected $fillable = [
        'type','number','doc_date','client_name','client_email','client_oib','notes',
        'subtotal','discount','total','status',
    ];

    protected $casts = [
        'doc_date' => 'date',
        'subtotal' => 'decimal:2',
        'discount' => 'decimal:2',
        'total' => 'decimal:2',
        'type' => BillingDocType::class,
    ];

    public function lines(): HasMany
    {
        return $this->hasMany(BillingLine::class, 'billing_document_id');
    }
}
