<?php

namespace App\Models;

use App\Enums\ContractStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Contract extends Model
{
    use HasFactory;

    protected $fillable = [
        'number','vehicle_id','driver_id',
        'date_from','date_to',
        'price','deposit','included_km','extra_km_rate',
        'notes','status',
        'pickup_km','return_km','fuel_level_pickup','fuel_level_return',
    ];

    protected $casts = [
        'date_from' => 'datetime',
        'date_to' => 'datetime',
        'price' => 'decimal:2',
        'deposit' => 'decimal:2',
        'included_km' => 'integer',
        'extra_km_rate' => 'decimal:2',
        'pickup_km' => 'integer',
        'return_km' => 'integer',
        'status' => ContractStatus::class,
    ];

    public function vehicle(): BelongsTo { return $this->belongsTo(Vehicle::class); }
    public function driver(): BelongsTo { return $this->belongsTo(Driver::class); }
}
