<?php

namespace App\Models;

use App\Enums\DamageStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Damage extends Model
{
    use HasFactory;

    protected $fillable = [
        'vehicle_id','driver_id','contract_id',
        'damage_date','description','cost','status','attachments','notes',
    ];

    protected $casts = [
        'damage_date' => 'date',
        'cost' => 'decimal:2',
        'status' => DamageStatus::class,
        'attachments' => 'array',
    ];

    public function vehicle(): BelongsTo { return $this->belongsTo(Vehicle::class); }
    public function driver(): BelongsTo { return $this->belongsTo(Driver::class); }
    public function contract(): BelongsTo { return $this->belongsTo(Contract::class); }
}
