<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LeasingPayment extends Model
{
    use HasFactory;

    protected $fillable = [
        'leasing_id','paid_at','amount','status','notes',
    ];

    protected $casts = [
        'paid_at' => 'date',
        'amount' => 'decimal:2',
    ];

    public function leasing(): BelongsTo { return $this->belongsTo(Leasing::class); }
}
