<?php

namespace App\Models;

use App\Enums\VehicleStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Vehicle extends Model
{
    use HasFactory;

    protected $fillable = [
        'make','model','registration','vin','year',
        'fuel_type','transmission','seats','doors','color',
        'start_km','current_km','status','notes','is_active',
    ];

    protected $casts = [
        'year' => 'integer',
        'start_km' => 'integer',
        'current_km' => 'integer',
        'is_active' => 'boolean',
        'status' => VehicleStatus::class,
    ];

    public function contracts(): HasMany { return $this->hasMany(Contract::class); }
    public function reservations(): HasMany { return $this->hasMany(Reservation::class); }
    public function serviceRecords(): HasMany { return $this->hasMany(ServiceRecord::class); }
    public function damages(): HasMany { return $this->hasMany(Damage::class); }
    public function leasings(): HasMany { return $this->hasMany(Leasing::class); }

    public function getDisplayNameAttribute(): string
    {
        return trim(($this->make ?? '').' '.($this->model ?? '')).' • '.$this->registration;
    }
}
