<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('vehicles', function (Blueprint $table) {
            $table->id();
            $table->string('make');
            $table->string('model');
            $table->string('registration')->unique();
            $table->string('vin')->nullable()->index();
            $table->unsignedSmallInteger('year')->nullable()->index();
            $table->string('fuel_type')->nullable()->index();
            $table->string('transmission')->nullable()->index();
            $table->unsignedTinyInteger('seats')->nullable();
            $table->unsignedTinyInteger('doors')->nullable();
            $table->string('color')->nullable();
            $table->unsignedInteger('start_km')->default(0);
            $table->unsignedInteger('current_km')->default(0);
            $table->string('status')->default('free')->index();
            $table->text('notes')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vehicles');
    }
};
