<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('service_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_id')->constrained('vehicles');
            $table->string('type')->index();
            $table->date('service_date')->index();
            $table->decimal('cost', 12, 2)->default(0);
            $table->text('description')->nullable();
            $table->boolean('is_completed')->default(true);
            $table->string('attachment_path')->nullable();
            $table->timestamps();
            $table->index(['vehicle_id', 'type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('service_records');
    }
};
