<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('leasing_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('leasing_id')->constrained('leasings')->cascadeOnDelete();
            $table->date('paid_at')->index();
            $table->decimal('amount', 12, 2)->default(0);
            $table->string('status')->default('paid')->index();
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('leasing_payments');
    }
};
