<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Vehicle;
use App\Models\Driver;
use App\Models\Item;

class DemoDataSeeder extends Seeder
{
    public function run(): void
    {
        Vehicle::firstOrCreate(
            ['registration' => 'ZG-0001-AA'],
            [
                'make' => 'Volkswagen',
                'model' => 'Golf',
                'vin' => 'WVWZZZTEST000001',
                'year' => 2020,
                'fuel_type' => 'diesel',
                'transmission' => 'manual',
                'seats' => 5,
                'doors' => 5,
                'color' => 'crna',
                'start_km' => 120000,
                'current_km' => 120000,
                'status' => 'free',
            ]
        );

        Driver::firstOrCreate(
            ['oib' => '12345678901'],
            [
                'first_name' => 'Marko',
                'last_name' => 'Marić',
                'phone' => '+38591111222',
                'email' => 'marko@example.com',
                'status' => 'active',
            ]
        );

        Item::firstOrCreate(['name' => 'Najam 1 dan'], ['unit' => 'dan', 'price' => 50, 'is_active' => true]);
        Item::firstOrCreate(['name' => 'Depozit'], ['unit' => 'kom', 'price' => 200, 'is_active' => true]);
        Item::firstOrCreate(['name' => 'Prekomjerni km'], ['unit' => 'km', 'price' => 0.20, 'is_active' => true]);
    }
}
