<!doctype html>
<html lang="hr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>RENTX • Admin</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,Noto Sans,sans-serif;background:#0b1220;color:#e5e7eb;margin:0}
    header{display:flex;align-items:center;justify-content:space-between;padding:18px 22px;border-bottom:1px solid rgba(255,255,255,.08);background:#0f172a}
    .brand{font-weight:800;letter-spacing:.08em}
    .btn{display:inline-block;padding:10px 12px;border-radius:12px;background:rgba(255,255,255,.08);border:1px solid rgba(255,255,255,.12);color:#e5e7eb;text-decoration:none}
    main{padding:22px}
    .grid{display:grid;grid-template-columns:repeat(3,minmax(0,1fr));gap:14px}
    .card{background:#0f172a;border:1px solid rgba(255,255,255,.08);border-radius:16px;padding:16px}
    .kpi{font-size:28px;font-weight:900;margin:2px 0}
    .muted{opacity:.75}
    @media (max-width:900px){.grid{grid-template-columns:1fr}}
  </style>
</head>
<body>
<header>
  <div class="brand">RENTX ADMIN</div>
  <div style="display:flex;gap:10px;align-items:center">
    <a class="btn" href="{{ route('home') }}">Početna</a>
    <form method="post" action="{{ route('admin.logout') }}">
      @csrf
      <button class="btn" type="submit">Odjavi se</button>
    </form>
  </div>
</header>

<main>
  <h1 style="font-size:20px;margin:0 0 10px">Kontrolna ploča (starter)</h1>
  <p class="muted" style="margin:0 0 18px">
    Ovo je početni admin panel bez dodatnih paketa. Sljedeći korak: CRUD za vozila, rezervacije i korisnike.
  </p>

  <div class="grid">
    <div class="card">
      <div class="muted">Vozila</div>
      <div class="kpi">0</div>
      <div class="muted">Za sada su statički podaci.</div>
    </div>
    <div class="card">
      <div class="muted">Rezervacije</div>
      <div class="kpi">0</div>
      <div class="muted">Kasnije povezujemo s bazom.</div>
    </div>
    <div class="card">
      <div class="muted">Poruke</div>
      <div class="kpi">0</div>
      <div class="muted">Kontakt forma ide u log / email.</div>
    </div>
  </div>
</main>
</body>
</html>
