<!doctype html>
<html lang="hr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>RENTX • Admin prijava</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,Noto Sans,sans-serif;background:#0b1220;color:#e5e7eb;margin:0}
    .wrap{min-height:100vh;display:grid;place-items:center;padding:24px}
    .card{width:100%;max-width:420px;background:#0f172a;border:1px solid rgba(255,255,255,.08);border-radius:16px;padding:22px;box-shadow:0 20px 50px rgba(0,0,0,.35)}
    h1{font-size:18px;margin:0 0 14px}
    label{display:block;font-size:12px;opacity:.9;margin:12px 0 6px}
    input{width:100%;padding:12px 12px;border-radius:12px;border:1px solid rgba(255,255,255,.12);background:#0b1220;color:#e5e7eb;outline:none}
    input:focus{border-color:rgba(99,102,241,.8)}
    .btn{margin-top:16px;width:100%;padding:12px;border-radius:12px;border:0;background:#6366f1;color:#fff;font-weight:700;cursor:pointer}
    .err{background:rgba(239,68,68,.12);border:1px solid rgba(239,68,68,.3);padding:10px 12px;border-radius:12px;margin:12px 0;font-size:13px}
    .hint{margin-top:12px;font-size:12px;opacity:.75}
    a{color:#a5b4fc;text-decoration:none}
  </style>
</head>
<body>
<div class="wrap">
  <div class="card">
    <h1>Admin prijava</h1>

    @if ($errors->any())
      <div class="err">
        {{ $errors->first() }}
      </div>
    @endif

    <form method="post" action="{{ route('admin.login.submit') }}">
      @csrf
      <label>Korisničko ime</label>
      <input name="username" value="{{ old('username') }}" autocomplete="username" required>

      <label>Lozinka</label>
      <input type="password" name="password" autocomplete="current-password" required>

      <button class="btn" type="submit">Prijavi se</button>
    </form>

    <div class="hint">
      Postavi pristup u <code>.env</code>: <code>ADMIN_USER</code> i <code>ADMIN_PASS</code>.
      <br>Vrati se na <a href="{{ route('home') }}">početnu</a>.
    </div>
  </div>
</div>
</body>
</html>
