@extends('layouts.landing')

@section('content')
    <section class="section">
        <div class="container">
            <div class="section__head">
                <h1>Kontakt</h1>
                <p class="muted">Ovo je demo forma – kasnije je spajamo na mail (SMTP) ili CRM.</p>
            </div>

            @if ($sent)
                <div class="note note--success">Hvala! Poruka je zabilježena (demo). U produkciji ćemo je slati na e-mail.</div>
            @endif

            <div class="grid grid--2">
                <div class="card">
                    <form method="post" action="{{ route('contact.submit') }}" class="form">
                        @csrf
                        <div class="row">
                            <label>Ime i prezime</label>
                            <input name="name" value="{{ old('name') }}" placeholder="npr. Ivan Horvat" required>
                            @error('name')<div class="err">{{ $message }}</div>@enderror
                        </div>
                        <div class="row">
                            <label>E-mail</label>
                            <input type="email" name="email" value="{{ old('email') }}" placeholder="npr. ivan@email.com" required>
                            @error('email')<div class="err">{{ $message }}</div>@enderror
                        </div>
                        <div class="row">
                            <label>Poruka</label>
                            <textarea name="message" rows="5" placeholder="Napišite ukratko što vam treba..." required>{{ old('message') }}</textarea>
                            @error('message')<div class="err">{{ $message }}</div>@enderror
                        </div>
                        <button class="btn btn--primary" type="submit">Pošalji</button>
                    </form>
                </div>

                <div class="card">
                    <h3>Info</h3>
                    <p class="muted">Za demo smo ostavili statične podatke. Kasnije ih stavljamo u CMS/Settings.</p>
                    <div class="kv">
                        <div><span class="k">Telefon</span><span class="v">+385 91 000 0000</span></div>
                        <div><span class="k">E-mail</span><span class="v">info@rentx.hr</span></div>
                        <div><span class="k">Radno vrijeme</span><span class="v">Pon–Pet 08:00–16:00</span></div>
                    </div>
                    <div class="note" style="margin-top:12px">
                        Admin panel: <a href="/admin" class="link">/admin</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
