@extends('layouts.landing')

@section('content')
    <section class="section">
        <div class="container">
            <div class="breadcrumbs">
                <a href="{{ route('home') }}">Početna</a>
                <span>/</span>
                <a href="{{ route('vehicles.index') }}">Vozila</a>
                <span>/</span>
                <span>{{ $vehicle['brand'] }} {{ $vehicle['model'] }}</span>
            </div>

            <div class="veh">
                <div class="veh__media">
                    <div class="veh__img">
                        <div class="placeholder">🚗</div>
                    </div>
                    <div class="veh__tags">
                        <span class="tag">{{ $vehicle['fuel'] }}</span>
                        <span class="tag">{{ $vehicle['transmission'] }}</span>
                        <span class="tag">{{ $vehicle['seats'] }} sjedala</span>
                        <span class="tag">{{ $vehicle['year'] }}</span>
                    </div>
                </div>

                <div class="veh__body">
                    <h1>{{ $vehicle['brand'] }} {{ $vehicle['model'] }}</h1>
                    <p class="lead">Idealno za grad i putovanja. Demo opis – kasnije dolazi iz baze.</p>

                    <div class="veh__price">
                        <div>
                            <div class="muted">Cijena po danu</div>
                            <div class="price">{{ number_format($vehicle['price_per_day_eur'], 0) }}€</div>
                        </div>
                        <div>
                            <div class="muted">Deposit</div>
                            <div class="price">{{ number_format($vehicle['deposit_eur'], 0) }}€</div>
                        </div>
                    </div>

                    <div class="veh__cta">
                        <a class="btn" href="{{ route('contact') }}">Rezerviraj sada</a>
                        <a class="btn btn--ghost" href="/admin" target="_blank" rel="noreferrer">Admin panel</a>
                    </div>

                    <div class="note">
                        <strong>Napomena:</strong> Ovo je početni front-end (UI). U sljedećem koraku povezujemo s bazom,
                        ugovorima, rezervacijama i naplatom.
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
