<!doctype html>
<html lang="hr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $title ?? 'RentX • Najam vozila' }}</title>
    <meta name="description" content="{{ $description ?? 'RentX – moderni najam vozila, rezervacije, ugovori i praćenje vozila.' }}">
    {{-- Landing CSS is plain/static (no Vite/NPM needed) --}}
    <link rel="stylesheet" href="{{ asset('assets/rentx/style.css') }}">
    <link rel="icon" href="/assets/rentx/favicon.svg" type="image/svg+xml">
</head>
<body>
<header class="nav">
    <div class="container nav__inner">
        <a href="{{ route('home') }}" class="logo">
            <span class="logo__mark">R</span>
            <span class="logo__text">RentX</span>
        </a>

        <button class="burger" id="burger" aria-label="Menu">
            <span></span><span></span><span></span>
        </button>

        <nav class="menu" id="menu">
            <a href="{{ route('vehicles.index') }}" class="menu__link">Vozila</a>
            <a href="{{ route('pricing') }}" class="menu__link">Cijene</a>
            <a href="{{ route('contact') }}" class="menu__link">Kontakt</a>
            <a href="/admin" class="btn btn--soft">Admin</a>
        </nav>
    </div>
</header>

<main>
    @yield('content')
</main>

<footer class="footer">
    <div class="container footer__inner">
        <div>
            <div class="footer__brand">RentX</div>
            <div class="footer__muted">Sustav za najam vozila: vozila, vozači, ugovori, rezervacije, računi i troškovi.</div>
        </div>
        <div class="footer__links">
            <a href="{{ route('vehicles.index') }}">Vozila</a>
            <a href="{{ route('pricing') }}">Cijene</a>
            <a href="{{ route('contact') }}">Kontakt</a>
        </div>
    </div>
    <div class="container footer__bottom">
        <span>© {{ date('Y') }} RentX</span>
        <span class="footer__muted">Izrada: Ivsoft Design</span>
    </div>
</footer>

<script>
    // simple mobile menu
    const burger = document.getElementById('burger');
    const menu = document.getElementById('menu');
    burger?.addEventListener('click', () => menu?.classList.toggle('menu--open'));
</script>
</body>
</html>
