<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LandingController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\AdminAuthController;

/*
|--------------------------------------------------------------------------
| Public (landing) routes (HR)
|--------------------------------------------------------------------------
| Front-end is dependency-free (no Tailwind/NPM required).
| CSS is in /public/assets/rentx/style.css
|--------------------------------------------------------------------------
*/

Route::get('/', [LandingController::class, 'home'])->name('home');
Route::get('/vozila', [LandingController::class, 'vehicles'])->name('vehicles.index');
Route::get('/vozila/{slug}', [LandingController::class, 'vehicleShow'])->name('vehicles.show');
Route::get('/cijene', [LandingController::class, 'pricing'])->name('pricing');
Route::get('/kontakt', [LandingController::class, 'contact'])->name('contact');
Route::post('/kontakt', [LandingController::class, 'sendContact'])->name('contact.send');

// Alias ako u šablonu postoji route('vehicles') ili link na /vehicles
Route::get('/vehicles', fn () => redirect()->route('vehicles.index'))->name('vehicles');

/*
|--------------------------------------------------------------------------
| Admin (starter - bez dodatnih paketa)
|--------------------------------------------------------------------------
| /admin -> dashboard (traži login)
| /admin/login -> login forma
|--------------------------------------------------------------------------
*/

Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/login', [AdminAuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AdminAuthController::class, 'login'])->name('login.submit');
    Route::post('/logout', [AdminAuthController::class, 'logout'])->name('logout');

    Route::middleware('admin')->group(function () {
        Route::get('/', [AdminController::class, 'dashboard'])->name('dashboard');
    });
});

// Friendly shortcut
Route::get('/panel', fn () => redirect('/admin'))->name('panel');
